<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
      <form id="globalConfigEdit">
        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label><?php echo e($model->key); ?></label>
              <input type="hidden" id="id" value="<?php echo e($model->id); ?>">
              <?php if($model->key == 'PRIMARY_COLOR'): ?>
                <input type="color" id="value" value="<?php echo e($model->value); ?>" class="form-control" required>  
              <?php elseif($model->key == 'PRIMARY_LOGO' || $model->key == 'SECONDARY_LOGO'): ?>
                <input type="file" id="value" value="<?php echo e($model->value); ?>" class="form-control" accept=".png" required>
              <?php else: ?>
                <input type="text" id="value" value="<?php echo e($model->value); ?>" class="form-control" placeholder="Enter Application Name" maxlength="50" required>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="form-group">
              <div class="callout callout-info">
                <h5>Description</h5>

                <p><?php echo e($model->description); ?></p>
              </div>
            </div>
          </div>
        </div>

        <?php if($model->key == 'PRIMARY_LOGO' || $model->key == 'SECONDARY_LOGO'): ?>
          <div class="row">
            <div class="col-sm-6">
              <div class="form-group">
                <label>Preview</label>
                <div class="preview">
                  <img src="<?php echo e(asset('storage/images/' . $model->key . '.png')); ?>" alt="<?php echo e($model->key); ?>">
                </div>
              </div>
            </div>
          </div>
        <?php endif; ?>

        <button type="submit" id="save" class="btn btn-primary">Save</button>
        <a href="<?php echo e(route('global-config')); ?>"><button type="button" class="btn btn-default">Cancel</button></a>
      </form>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
  <script type="text/javascript">
    $("#globalConfigEdit").on('submit', function (e) {
      e.preventDefault();

      $("#save").attr('disabled', true);

      let form = new FormData();
      form.append('id', $("#id").val());
      form.append('value', $("#value").val());
      form.append('image', $("#value").prop('files') ? $("#value").prop('files')[0] : '');

      $.ajax({
        headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          url: '/update-global-config',
          data: form,
          type: 'post',
          cache: false,
          contentType: false,
          processData: false
      }).done(function(data) {
        data = JSON.parse(data);
        $("#save").attr('disabled', false);

        if (data.success) {
          showSuccess('Data updated successfully');
        } else {
          showError();
        }
      }).catch(function () {
        showError();
        $("#save").attr('disabled', false);
      });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\resources\views/admin/global-config-edit.blade.php ENDPATH**/ ?>