

<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <!-- <form id="createUser"> -->
            <form action="<?php echo e(route('admin.tax_rates.new')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-name"><?php echo e(__('Name')); ?></label>
                            <input type="text" name="name" id="i-name"
                                class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>"
                                value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('Name')); ?>">
                            <?php if($errors->has('name')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('name')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-percentage"><?php echo e(__('Percentage')); ?></label>
                            <div class="input-group">
                                <input type="text" name="percentage" id="i-percentage"
                                    class="form-control<?php echo e($errors->has('percentage') ? ' is-invalid' : ''); ?>"
                                    value="<?php echo e(old('percentage')); ?>" placeholder="<?php echo e(__('Percentage')); ?>">
                                <div class="input-group-append">
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                            <?php if($errors->has('percentage')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('percentage')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-type"><?php echo e(__('Type')); ?></label>
                            <select name="type" id="i-type"
                                class="custom-select<?php echo e($errors->has('type') ? ' is-invalid' : ''); ?>">
                                <?php $__currentLoopData = [0 => __('Inclusive'), 1 => __('Exclusive')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('type') == $key): ?> selected <?php endif; ?>>
                                        <?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('type')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('type')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="i-regions"><?php echo e(__('Regions')); ?></label>
                            <select name="regions[]" id="i-regions"
                                class="custom-select<?php echo e($errors->has('regions') ? ' is-invalid' : ''); ?>" multiple>
                                <?php $__currentLoopData = config('countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>" <?php if(old('regions') !== null && in_array($key, old('regions'))): ?> selected <?php endif; ?>>
                                        <?php echo e(__($value)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('regions')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('regions')); ?></strong>
                                </span>
                            <?php endif; ?>
                            <small id="regionsHelp"
                                class="form-text text-muted"><?php echo e(__('Leave empty to apply the tax rate on all regions.')); ?></small>
                        </div>
                    </div>
                </div>
                <button type="submit" id="save" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                <a href="<?php echo e(route('admin.tax_rates')); ?>"><button type="button"
                        class="btn btn-default"><?php echo e(__('Back')); ?></button></a>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jupitermeet_cc\JupiterMeet_2.5.0\jupitermeet\resources\views/admin/tax-rates/new.blade.php ENDPATH**/ ?>