

<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php echo $__env->make('include.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row">
                <a href="<?php echo e(route('admin.plans.new')); ?>"><button class="btn btn-primary btn-sm" id="createCoupon"
                        title="<?php echo e(__('Create User')); ?>"><?php echo e(__('Create')); ?></button></a>
            </div>
            <br>
            <table class="table table-bordered table-striped table-hover">
                <div class="d-flex">
                    <thead>
                        <tr>
                            <th><?php echo e(__('ID')); ?></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Currency')); ?></th>
                            <th><?php echo e(__('Monthly amount')); ?></th>
                            <th><?php echo e(__('Yearly amount')); ?></th>
                            <th><?php echo e(__('Description')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($value->id); ?></td>
                                <td><a href="<?php echo e(route('admin.plans.edit', $value->id)); ?>"
                                        class="text-truncate"><?php echo e($value->name); ?></a>
                                    <?php if(!$value->hasPrice()): ?>
                                        <span class="badge badge-secondary"><?php echo e(__('Default')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($value->currency ? $value->currency : '-'); ?></td>
                                <td><?php echo e($value->amount_month ? $value->amount_month : '-'); ?></td>
                                <td><?php echo e($value->amount_year ? $value->amount_year : '-'); ?></td>
                                <td><?php echo e($value->description); ?></td>
                                <td>
                                    <?php if($value->id == 1): ?>
                                        -
                                    <?php else: ?>
                                        <div class="custom-control custom-switch">
                                            <input type="checkbox" class="custom-control-input plan-status"
                                                data-id="<?php echo e($value->id); ?>" id="customSwitch<?php echo e($value->id); ?>"
                                                <?php echo e($value->status == 1 ? 'checked' : ''); ?>>
                                            <label class="custom-control-label"
                                                for="customSwitch<?php echo e($value->id); ?>"></label>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.plans.edit', $value->id)); ?>">
                                        <button class="btn btn-primary btn-sm">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th><?php echo e(__('ID')); ?></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Currency')); ?></th>
                            <th><?php echo e(__('Monthly amount')); ?></th>
                            <th><?php echo e(__('Yearly amount')); ?></th>
                            <th><?php echo e(__('Description')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Action')); ?></th>
                        </tr>
                    </tfoot>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\jupitermeet_cc\JupiterMeet_2.5.0\jupitermeet\resources\views/admin/plans/index.blade.php ENDPATH**/ ?>