<?php $__env->startSection('title', __('Meta title')); ?>
<?php $__env->startSection('description', __('Meta description')); ?>
<?php $__env->startSection('keywords', __('Meta keywords')); ?>

<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('css/home.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="dashboard-section">
        <div id="permission"></div>
        <div class="container">
            <div class="row d-flex justify-content-center align-items-center">
                <div class="col col-md-6 col-12 pos-relative">
                    <div class="left-center">
                        <p class="site-detail"><?php echo getContent('HOME_PAGE'); ?></p>
                    </div>
                </div>
                <div class="col col-md-6 col-12 pos-relative">
                    <div class="right-center">
                        <div class="entering-info">
                            <form id="meeting">
                                <div class="input-group mb-2">
                                    <input type="text" name="id" class="form-control conference-id" id="conferenceId"
                                        aria-label="<?php echo e(__('Meeting ID')); ?>" aria-describedby="initiate" required autofocus
                                        autocomplete="off" maxlength="9" pattern="^[a-zA-Z0-9]+$"
                                        title="<?php echo e(__('Special characters and spaces are not allowed')); ?>" />
                                    <label class="form-control-placeholder"
                                        for="conferenceId"><?php echo e(__('Meeting ID')); ?></label>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit" id="initiate"
                                            title="<?php echo e(__('Start the meeting')); ?>"><i class="fa fa-arrow-right"></i></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        let errorExist = "<?php echo e($errors->any()); ?>";

        if (errorExist) {
            showError("<?php echo e($errors->first()); ?>");
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.application', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/home.blade.php ENDPATH**/ ?>