<?php $__env->startSection('page', $page); ?>
<?php $__env->startSection('title', getSetting('APPLICATION_NAME') . ' | ' . $page); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <a href="<?php echo e('languages/add'); ?>"><button class="btn btn-primary btn-sm ml-1" id="createLanguage"
                        title="<?php echo e(__('Create Language')); ?>"><?php echo e(__('Create')); ?></button></a>
                <a href="<?php echo e('languages/download-english'); ?>"><button class="btn btn-warning btn-sm ml-1"
                        title="<?php echo e(__('Download English File')); ?>"><?php echo e(__('Download English File')); ?></button></a>
            </div>
            <br>
            <table id="languages" class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Code')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Direction')); ?></th>
                        <th><?php echo e(__('Default')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->code); ?></td>
                            <td><?php echo e($value->name); ?></td>
                            <td><?php echo e(strtoupper($value->direction)); ?></td>
                            <td>
                                <?php if($value->default == 'yes'): ?>
                                    <span class="badge badge-success"><?php echo e(__('Yes')); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-warning"><?php echo e(__('No')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($value->status == 'active'): ?>
                                    <span class="badge badge-success"><?php echo e(__('Active')); ?></span>
                                <?php else: ?>
                                    <span class="badge badge-danger"><?php echo e(__('Inactive')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="/languages/edit/<?php echo e($value->id); ?>">
                                    <button class="btn btn-primary btn-sm" title="<?php echo e(__('Edit')); ?>">
                                        <i class="fa fa-edit"></i>
                                    </button>
                                </a>
                                <button class="btn btn-danger btn-sm deleteLanguage" data-id="<?php echo e($value->id); ?>"
                                    title="<?php echo e(__('Delete')); ?>">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th><?php echo e(__('ID')); ?></th>
                        <th><?php echo e(__('Code')); ?></th>
                        <th><?php echo e(__('Name')); ?></th>
                        <th><?php echo e(__('Direction')); ?></th>
                        <th><?php echo e(__('Default')); ?></th>
                        <th><?php echo e(__('Status')); ?></th>
                        <th><?php echo e(__('Action')); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.1.0\resources\views/admin/language/index.blade.php ENDPATH**/ ?>