<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <!-- Styles -->
    <style type="text/css">
        :root {
            --primary-color: <?php echo e(getSetting('PRIMARY_COLOR')); ?>;
            --primary-color-disabled: <?php echo e(getSetting('PRIMARY_COLOR_DISABLED')); ?>;
            --secondary-color: <?php echo e(getSetting('SECONDARY_COLOR')); ?>;
        }
    </style>
    <link href="<?php echo e(asset('css/app.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/fa.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/toastr.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link rel="icon" type="image/png" href="<?php echo e(asset('storage/images/FAVICON.png')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body>
    <div id="app">
        <nav class="navbar navbar-expand-md shadow-sm application-header">
                <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                    <img src="<?php echo e(asset('storage/images/PRIMARY_LOGO.png')); ?>" alt="<?php echo e(getSetting('APPLICATION_NAME')); ?>" width="160px">
                </a>
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="<?php echo e(__('Toggle navigation')); ?>">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <!-- Left Side Of Navbar -->
                    <ul class="navbar-nav mr-auto">

                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        <?php if(auth()->guard()->guest()): ?>
                            <?php if(getSetting('AUTH_MODE') == 'enabled' && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('pricing')); ?>">Pricing</a>
                                </li>
                            <?php endif; ?>

                            <?php if(Route::has('login') && getSetting('AUTH_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(Route::has('register') && getSetting('AUTH_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php if(Auth::user()->role == 'admin'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('admin')); ?>"><?php echo e(__('Admin')); ?></a>
                                </li>
                            <?php endif; ?>

                            <?php if(Auth::user()->plan_type == 'free' && getSetting('AUTH_MODE') == 'enabled' && getSetting('PAYMENT_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('pricing')); ?>">
                                        <span class="badge badge-warning p-1">Upgrade</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if(getSetting('AUTH_MODE') == 'enabled'): ?>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                                </li>
                            <?php endif; ?>

                            <li class="nav-item dropdown">
                                <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                                    <?php echo e(Auth::user()->username); ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                                    <?php if(getSetting('PAYMENT_MODE') == 'enabled'): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('profile')); ?>">
                                            Profile
                                        </a>
                                    <?php endif; ?>
                                    <a class="dropdown-item" href="<?php echo e(route('changePassword')); ?>">
                                        Change Password
                                    </a>
                                    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                        <?php echo e(__('Logout')); ?>

                                    </a>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
        </nav>

        <main class="py-4 mb-5 mb-md-0">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <footer class="application-footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12 col-md-12 ">
                        <div class="row">
                            <div class="col-md-4 p-0 text-center text-md-left">
                                <p class=" mb-0">© <?php echo e(getSetting('APPLICATION_NAME')); ?> <?php echo e(date('Y')); ?></p>
                            </div>
                            <div class="col-md-8 text-md-right text-center">
                                <ul class="footer-links">
                                    <li><a href="<?php echo e(route('privacyPolicy')); ?>">Privacy Policy</a></li>
                                    <li><a href="<?php echo e(route('termsAndConditions')); ?>">Terms &amp; Conditions</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\JupiterMeet\JupiterMeet_2.0.1\resources\views/layouts/application.blade.php ENDPATH**/ ?>